# ---------------------------------------------------
# 1. Fetching the Auth Code 
# ---------------------------------------------------

import requests, json

client_id = 'testclient'
client_secret = 'testpass'
redirect_uri = 'inapp'
api_endpoint = 'https://api.sandbox.neoogilvy.com' # for production, use https://api.neoogilvy.com
access_token_generate_url = api_endpoint + '/oauth/authorize?response_type=code&client_id=' + client_id + '&redirect_uri=' + redirect_uri + '&state=845763'


# build the POST request parameters and send authorized = yes as data
params = {
    'authorized': "yes"
}
 
# Perform a POST request to obtain the 'auth_code'
response = requests.post(access_token_generate_url, data = params)


# Parse the response json to retrieve access token and refresh token
# SAMPLE RESPONSE
# {
#   "authorization_token" : "b51eb179e6363d27065ff4106a0774c8bb892577"
# }

print ""

if response.status_code == 200:
    auth_code = response.json().get('authorization_token')
    print 'Authorization Code: ' + auth_code
else:
    print 'There was a problem in creating the Authorization Code : ' + str(response.status_code) + ' :: ' + response.text
 

 
# ---------------------------------------------------
# 2. Generating the Access and Refresh Token
# ---------------------------------------------------
 
# import requests
 
access_token_generate_url = api_endpoint + '/oauth'


# build the POST request parameters
params = {
    'redirect_uri': redirect_uri,
    'client_id' : client_id, 
    'client_secret' : client_secret,
    'code' : auth_code,
    'grant_type' : 'authorization_code',
}
 
# Perform a POST request to obtain the 'auth_code'
response = requests.post(access_token_generate_url, data = params)

 
# Parse the response json to retrieve access token and refresh token
# SAMPLE RESPONSE
# {
#   "access_token" : "bf60c59ea896b46885de91307a3888bd6fe0259f",
#   "expires_in":3600,
#   "token_type":"Bearer",
#   "scope":null,
#   "refresh_token":"393b4061d46ed7b95004e60fc76601ed185b9a08"
# }
print ""

if response.status_code == 200:
    access_token = response.json().get('access_token')
    refresh_token = response.json().get('refresh_token')
    print 'Access token : ' + access_token
    print 'Refesh token : ' + refresh_token
else:
    print 'Could not obtain Access and Refresh token, failed with status code : ' + str(response.status_code) + ' :: ' + response.text

 
# ---------------------------------------------------
# 3. Refreshing the Access Token
# ---------------------------------------------------

# import requests

# refresh_access_token_url = api_endpoint + '/oauth'
 
# # build the POST request parameters
# params = {
#     'client_id' : client_id, 
#     'client_secret' : client_secret,
#     'refresh_token' : refresh_token,
#     'grant_type' : 'refresh_token',
# }
 
# # Perform a POST request to obtain the refreshed access token
# response = requests.post(refresh_access_token_url, data = params)


# # Parse the response json (shown below) to retrieve the refreshed access token 
# # SAMPLE RESPONSE
# # {
# #   "access_token":"6d8db05ac28b38d29a1ec32f401753469ec35869",
# #   "expires_in":3600,
# #   "token_type":"Bearer",
# #   "scope":null
# # }
# print ""

# if response.status_code == 200:
#     access_token = response.json().get('access_token')
#     print 'Refreshed Access token : ' + access_token
# else:
#     print 'Could not refresh the Access token, failed with status code : ' + str(response.status_code) + ' :: ' + response.text




# ---------------------------------------------------
# 4. Uploading Leads API
# ---------------------------------------------------

uploading_leads_url = api_endpoint + '/siteserve/upload'
 
# represent leads to be uploaded as python list of dict(s)

leads = [{
    "campaign_id":          "163051",
    "campaign_name":        "2014 Q4|IBM_Non-CA_S&D_Smarter Cities & SLG|Non-Intel|NYC|USA",
    "publisher_id":         "I/EMEDIA (00104221)",
    "placement_name":       "GovLoop|Dedication Email and Social Cast|1x1",
    "source_site":          "isource",
    "unique_order_number":  "iordnum",
    "title":                "Mr",
    "first_name":           "John",
    "middle_name":          "middle name",
    "last_name":            "Smith",
    "job_title":            "job title",
    "company":              "Acne Corporation",
    "company_size":         "company size",
    "address_line_1":       "address line 1",
    "address_line_2":       "address line 2",
    "address_line_3":       "address line 3",
    "city":                 "New York City",
    "state":                "NY",
    "zip_code":             "10021",
    "country":              "US",
    "phone":                "9876543210",
    "fax":                  "9876543211",
    "email":                "john.smith126@company.com",
    "ctdochk":              "ctdochk",
    "ts_received":          "tsrecv",
    "extension":            "extension number",
    "department":           "department name",
    "geography":            "cgeography",
    "ov_code":              "ov26863",
    "ww_score":             "wwscore",
    "iadmid":               "iadmid",
    "custinfo1":            "customer info 1",
    "custinfo2":            "customer info 2",
    "privacy":              "Y",
    "tactic":               "000000SI",
    "response_type":        "resptype",
    "asset_name":           "assetname",
    "questionnum1_ooemail": "Q_XSYS:OOEMAIL",
    "email_verification":   "CHECKED",
    "questionnum2_ootele":  "Q_XSYS:OOTELE",
    "phone_verification":   "CHECKED",
    "questionnum3_oopostal":"Q_XSYS:OOPOSTAL",
    "zipcode_verification": "NOT CHECKED",
    "timestamp":            "timestamp",
    "offer_code":           "10000638",
    "channel":              "Digital Inbound:Content Syndication",
    "interaction_type":     "CONTSYND"
},
# { // second lead },
#{ // third lead },
#{ // fourth lead },
]

# Set the bearer authorization token in header
headers = { 'Authorization': 'Bearer ' + access_token,
            'Content-Type' : 'application/json' }
 
#stringify the leads data to be uploaded for POST request's body
data = json.dumps(leads)
print ""
 
# Make a POST request to submit the 'lead(s)'
response = requests.post(uploading_leads_url, data = data, headers = headers)


# Parse the response json (shown below) to retrieve the required information 
# SAMPLE RESPONSE
# {
#   "response":{
#       "request_id":"d65613aa069c45469f0b9e1b5efa1863",
#       "status":"Success",
#       "submitted_leads":1,
#       "uploaded_leads":1,
#       "duplicate_leads":0,
#       "invalid_leads":0
#   }
#}

if response.status_code == 200:
    response = json.loads(response.text)
    response = response.get('response')
    request_id = response.get('request_id')
    print 'Request ID : ', request_id
 
    status = response.get('status')
    submitted_leads = int(response.get('total_leads'))
    uploaded_leads  = int(response.get('uploaded_leads'))
    duplicate_leads = int(response.get('duplicate_leads'))
    invalid_leads   = int(response.get('invalid_leads'))
    assert submitted_leads == uploaded_leads + duplicate_leads + invalid_leads, 'Total submitted leads is NOT equal to sum of uploaded, duplicate and invalid leads'

    if status.lower() == 'success':
        print "This lead upload request has been processed successfully"
    else:
        print "Lead upload failed because of the following error : " + str(response.get('errors'))
else:
    print 'Could not submit leads, failed with status code : ' + str(response.status_code) + ' :: ' + response.text




# ---------------------------------------------------
# 5. Getting the status of a Request
# ---------------------------------------------------

# import requests

status_request_url = api_endpoint + '/siteserve/status/' + request_id

# Set the bearer authorization token in header
headers = { 'Authorization': 'Bearer ' + access_token }
 
# Make the GET request to obtain the 'auth_code'
response = requests.get(status_request_url, headers = headers)


# Parse the response json (shown below) to retrieve the refreshed access token 
# SAMPLE RESPONSE
# {
#   "request_id":"d65613aa069c45469f0b9e1b5efa1863",
#   "created_date":"2015-03-03 12:10:44",
#   "response":{
#       "request_id":"d65613aa069c45469f0b9e1b5efa1863",
#       "status":"Success",
#       "submitted_leads":1,
#       "uploaded_leads":1,
#       "duplicate_leads":0,
#       "invalid_leads":0
#   }
#}
# for attr in dir(response):
#     print "response.%s = %s" % (attr, getattr(response, attr))

print ""

if response.status_code == 200:
    response = response.json()
    response = response.get('response')
 
    status = response.get('status')
    submitted_leads = int(response.get('total_leads'))
    uploaded_leads  = int(response.get('uploaded_leads'))
    duplicate_leads = int(response.get('duplicate_leads'))
    invalid_leads   = int(response.get('invalid_leads'))
    assert submitted_leads == uploaded_leads + duplicate_leads + invalid_leads, 'Total submitted leads is NOT equal to sum of uploaded, duplicate and invalid leads'

    if status.lower() == 'success':
        print "This lead upload request has been processed successfully"
    else:
        print "Lead upload failed because of the following error(s) : " + str(response.get('errors'))
else:
    print 'Could not retrieve feed upload status, failed with status code : ' + str(response.status_code) + ' :: ' + response.text