<?php
class SiteServeAPI {

    public $clientId        = null;
    public $clientPassword  = null;
    public $authToken       = null;
    public $refreshToken    = null;

    public $apiEndPoint     = 'https://api.neoogilvy.com'; // for production, use https://api.neoogilvy.com

    public function __construct( $clientId, $clientPassword ) {
        $this->clientId = $clientId;
        $this->clientPassword = $clientPassword;
    }

    public function getAuthToken() {
        $requestEndpoint = '/oauth/authorize?response_type=code&client_id=' . $this->clientId . '&redirect_uri=inapp&state=init';
        $authResponse = $this->call( $this->apiEndPoint . $requestEndpoint, 'authorized=yes', 'form' );
        $this->authToken = $authResponse['authorization_token'];
    }

    public function getAccessToken() {
        $requestEndpoint = '/oauth';
        $postData = array(
                        "client_id" => $this->clientId,
                        "client_secret" => $this->clientPassword,
                        "code" => $this->authToken,
                        "grant_type" => "authorization_code",
                        "redirect_uri" => "inapp",
                    );
        $response = $this->call( $this->apiEndPoint . $requestEndpoint, json_encode( $postData ) );
        $this->accessToken = $response['access_token'];
        $this->refreshToken = $response['refresh_token'];
    }

    public function refreshAccessToken() {
        $requestEndpoint = '/oauth';
        $postData = array(
                        "client_id" => $this->clientId,
                        "client_secret" => $this->clientPassword,
                        "grant_type" => "refresh_token",
                        "refresh_token" => $this->refreshToken,
                    );
        $response = $this->call( $this->apiEndPoint . $requestEndpoint, json_encode( $postData ) );
        $this->accessToken = $response['access_token'];
    }

    public function uploadLeads( $leadArray ) {
        $requestEndpoint = '/siteserve/upload';
        $response = $this->call( $this->apiEndPoint . $requestEndpoint, json_encode( $leadArray ) );
        return $response;    
    }

    public function getStatus( $requestId = null ) {
        $requestEndpoint = '/siteserve/status';
        if( !is_null( $requestId ) ) $requestEndpoint .= '/' . $requestId;
        $response = $this->call( $this->apiEndPoint . $requestEndpoint );
        return $response;
    }

    public function call( $url, $data = false, $headerType = 'json' ) {
        $ch = curl_init();

        $headers = array();
        $headers[] = 'Accept: application/json';
        $headers[] = $headerType == 'json' ? 'Content-Type: application/json' : 'Content-Type: application/x-www-form-urlencoded';
        if( $this->accessToken ) $headers[] = 'Authorization: Bearer ' . $this->accessToken;

        curl_setopt( $ch, CURLOPT_URL, $url );
        curl_setopt( $ch, CURLOPT_HTTPHEADER, $headers ); 
        curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
        curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, true );
        if( $data ) {
            curl_setopt( $ch, CURLOPT_POST, true );
            curl_setopt( $ch, CURLOPT_POSTFIELDS, $data );
        }
        curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, true );
        $response = curl_exec( $ch );

        if (curl_errno($ch)) print_r( curl_error( $ch ) );
        return json_decode( $response, true );
    }
}
