package com.cdm.feed;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;


public class SiteServeAuthentication {
    private final static Logger log = Logger.getLogger(SiteServeAuthentication.class);
    private static String api_endpoint = "https://api.sandbox.neoogilvy.com"; // for production, use https://api.neoogilvy.com
    private static String clientId = "testclient";
    private static String clientSecret = "testpass";    
    private static String redirectURI = "inapp";
    private static String randomNumber = "12334";

    public static void main(String[] args) {
        
        String authToken = getAuthenticationToken(clientId, redirectURI, randomNumber);
        log.info(" Authentication Token: " + authToken);
        
        SiteServe siteServeObj2 = getAccessToken(clientId, clientSecret, authToken, "authorization_code", redirectURI);
        log.info(" Access Token: " + siteServeObj2.getAccess_token() + " Refresh Token: " + siteServeObj2.getRefresh_token() + "Expires in: " + siteServeObj2.getExpires_in());
        
        SiteServe siteServeObj3 = getRefreshAccessToken(clientId, clientSecret, "refresh_token", siteServeObj2.getRefresh_token());       
        log.info(" Access Token: " + siteServeObj3.getAccess_token());
        
        uploadLeads(siteServeObj3.getAccess_token());
    }
    
    public static String getAuthenticationToken(String clientId, String redirectURI, String randomNumber) {
        
        HttpClient httpClient = new DefaultHttpClient();       
        String authorization_token = null;
        try {
            HttpPost request = new HttpPost(api_endpoint + "/oauth/authorize?response_type=code&client_id=" + clientId + "&redirect_uri=inapp&state=32434");
            List<NameValuePair> nameValuePairs=new ArrayList<NameValuePair>();
            nameValuePairs.add(new BasicNameValuePair("authorized", "yes"));
            request.addHeader("Content-Type", "application/x-www-form-urlencoded");
            request.addHeader("Accept","application/json");
            request.setEntity(new UrlEncodedFormEntity(nameValuePairs));            
            HttpResponse response = httpClient.execute(request); 
            String str = response.getHeaders("Location")[0].toString();
            authorization_token = str.substring(str.indexOf("code=")+5, str.indexOf("&"));
        }catch (Exception ex) {
            log.error("Exception in SiteServeAuthentication.refreshAccessToken() method" + ex);
        } finally {
            httpClient.getConnectionManager().shutdown();
        }
        return authorization_token;       
    }
    
    public static SiteServe getAccessToken(String clientId, String clientSecret, String code, String grantType, String redirectURI) {
        
        HttpClient httpClient = new DefaultHttpClient();        
        String output = null;
        SiteServe siteServe= null;
        try {
            HttpPost request = new HttpPost(api_endpoint + '/oauth');
            StringEntity params =new StringEntity("{\"client_id\":" + "\"" + clientId + "\"" + ",\"client_secret\":" + "\"" + clientSecret + "\"" + ",\"redirect_uri\":" + "\"" + redirectURI + "\"" + ",\"grant_type\":" + "\"" + grantType + "\"" +",\"code\":" + "\"" + code+ "\"" +"} ");
            request.addHeader("content-type", "application/json");
            request.addHeader("Accept","application/json");
            request.setEntity(params);
            HttpResponse response = httpClient.execute(request); 
            java.io.File tempFile  = new java.io.File("/tmp/" + "AccessToken.json"); 
            FileOutputStream fopData  = new FileOutputStream(tempFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));            
            log.info(" Authentication Token, Output from Server .... \n");
            while ((output = br.readLine()) != null) {               
                fopData.write((output +"\n").getBytes(),0,(output +"\n").getBytes().length);
            }
            fopData.flush();
            fopData.close();
            JsonFactory jsonFactory = new JsonFactory();
            JsonParser jsonParser = jsonFactory.createJsonParser(new File("/tmp/" + "AccessToken.json"));            
            ObjectMapper mapper = new ObjectMapper();            
            while((jsonParser.nextToken() != null) && (jsonParser.nextToken() != JsonToken.END_ARRAY)) {
                try {                
                    siteServe =  mapper.readValue(jsonParser, SiteServe.class);                                    
                } catch (JsonGenerationException e) {
                    log.error("Exception in SiteServeAuthentication 's getAccessToken method: " + e);
                } catch (JsonMappingException e) {
                    log.error("Exception in SiteServeAuthentication 's getAccessToken method: " + e);
                } catch (IOException e) {
                    log.error("Exception in SiteServeAuthentication 's getAccessToken method: " + e);
                }
            }                       
        }catch (Exception ex) {
            log.error("Exception in SiteServeAuthentication.getAccessToken() method" + ex);
        } finally {
            httpClient.getConnectionManager().shutdown();            
        }
        return siteServe;
    }
    
    public static SiteServe getRefreshAccessToken(String clientId, String clientSecret, String grantType, String refreshToken) {
        
        HttpClient httpClient = new DefaultHttpClient();        
        String output = null;
        SiteServe siteServe= null;
        try {
            HttpPost request = new HttpPost(api_endpoint + '/oauth');
            StringEntity params =new StringEntity("{\"client_id\":" + "\"" + clientId + "\"" + ",\"client_secret\":" + "\"" + clientSecret + "\"" + ",\"grant_type\":" + "\"" + grantType + "\"" +",\"refresh_token\":" + "\"" + refreshToken+ "\"" +"} ");
            request.addHeader("content-type", "application/json");
            request.addHeader("Accept","application/json");
            request.setEntity(params);
            HttpResponse response = httpClient.execute(request); 
            java.io.File tempFile  = new java.io.File("/tmp/" + "RefreshAccessToken.json"); 
            FileOutputStream fopData  = new FileOutputStream(tempFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));            
            log.info(" Authentication Token, Output from Server .... \n");
            while ((output = br.readLine()) != null) {               
                log.info("Output ==> " + output);
                fopData.write((output +"\n").getBytes(),0,(output +"\n").getBytes().length);
            }
            fopData.flush();
            fopData.close();
            JsonFactory jsonFactory = new JsonFactory();
            JsonParser jsonParser = jsonFactory.createJsonParser(new File("/tmp/" + "RefreshAccessToken.json"));            
            ObjectMapper mapper = new ObjectMapper();            
            while((jsonParser.nextToken() != null) && (jsonParser.nextToken() != JsonToken.END_ARRAY)) {
                try {                
                    siteServe =  mapper.readValue(jsonParser, SiteServe.class);                                    
                } catch (JsonGenerationException e) {
                    log.error("Exception in SiteServeAuthentication 's refreshAccessToken method: " + e);
                } catch (JsonMappingException e) {
                    log.error("Exception in SiteServeAuthentication 's refreshAccessToken method: " + e);
                } catch (IOException e) {
                    log.error("Exception in SiteServeAuthentication 's refreshAccessToken method: " + e);
                }
            }            
                       
        }catch (Exception ex) {
            log.error("Exception in SiteServeAuthentication.refreshAccessToken() method" + ex);
        } finally {
            httpClient.getConnectionManager().shutdown();
        }
        return siteServe;
    }    
    
    public static void uploadLeads(String accessToken) {
        
        HttpClient httpClient = new DefaultHttpClient();        
        String output = null;        
        try {
            HttpPost request = new HttpPost(api_endpoint + "/siteserve/upload");
            StringEntity params =new StringEntity("[{\"campaign_id\":" + "\"" + "163051" + "\"" + ",\"campaign_name\":" + "\"" + "2010 Q4|IBM_Non-CA_IT_Rational CS|NonIntel|NYC|USA" + "\"" + ",\"publisher_id\":" + "\"" + "I/EMEDIA (00104221)" + "\"" +",\"placement_name\":" + "\"" + "AVIATION WEEK|Systems - Content Syndication|0x0" + "\""
                    +",\"source_site\":" + "\"" + "TECHTARGET" + "\"" +",\"unique_order_number\":" + "\"" + "23" + "\"" +",\"title\":" + "\"" + "Mr" + "\"" +",\"first_name\":" + "\"" + "John" + "\"" 
                    +",\"middle_name\":" + "\"" + "E." + "\"" +",\"last_name\":" + "\"" + "Smith" + "\"" +",\"job_title\":" + "\"" + "CEO" + "\"" +",\"company\":" + "\"" + "Acne Corporation" + "\"" 
                    +",\"company_size\":" + "\"" + "250 to 499" + "\"" +",\"address_line_1\":" + "\"" + "address line 1" + "\"" +",\"address_line_2\":" + "\"" + "address line 2" + "\"" +",\"address_line_3\":" + "\"" + "address line 3" + "\"" 
                    +",\"city\":" + "\"" + "New York City" + "\"" +",\"state\":" + "\"" + "NY" + "\"" +",\"zip_code\":" + "\"" + "10021" + "\"" +",\"country\":" + "\"" + "US" + "\"" 
                    +",\"phone\":" + "\"" + "9876543210" + "\"" +",\"fax\":" + "\"" + "9876543211" + "\"" +",\"email\":" + "\"" + "john.smith12@company.com" + "\"" +",\"ts_received\":" + "\"" + "2015-03-01 23:13:19" + "\"" 
                    +",\"extension\":" + "\"" + "Jr." + "\"" +",\"department\":" + "\"" + "department name" + "\"" +",\"geography\":" + "\"" + "cgeography" + "\"" +",\"ov_code\":" + "\"" + "ov26863" + "\"" 
                    +",\"ww_score\":" + "\"" + "wwscore" + "\"" +",\"iadmid\":" + "\"" + "iadmid" + "\"" +",\"custinfo1\":" + "\"" + "customer info 1" + "\"" +",\"custinfo2\":" + "\"" + "customer info 2" + "\"" 
                    +",\"privacy\":" + "\"" + "cprivacy" + "\"" +",\"tactic\":" + "\"" + "000000SI" + "\"" +",\"response_type\":" + "\"" + "WEBRESP" + "\"" +",\"asset_name\":" + "\"" + "assetname" + "\"" 
                    +",\"questionnum1_ooemail\":" + "\"" + "Q_XSYS:OOEMAIL" + "\"" +",\"email_verification\":" + "\"" + "CHECKED" + "\"" +",\"questionnum2_ootele\":" + "\"" + "Q_XSYS:OOTELE" + "\"" +",\"phone_verification\":" + "\"" + "CHECKED" + "\"" 
                    +",\"questionnum3_oopostal\":" + "\"" + "Q_XSYS:OOPOSTAL" + "\"" +",\"zipcode_verification\":" + "\"" + "NOT CHECKED" + "\"" +",\"timestamp\":" + "\"" + "2014-03-21 11:38:52" + "\"" + ",\"offer_code\":" + "\"" + "10000638" + "\"" + ",\"channel\":" + "\"" + "Digital Inbound:Content Syndication" + "\"" + ",\"interaction_type\":" + "\"" + "CONTSYND" + "\""+"}] ");
            
            request.addHeader("Authorization","Bearer " + accessToken);
            request.addHeader("content-type", "application/json");
            request.addHeader("Accept","application/json");
            request.setEntity(params);
            HttpResponse response = httpClient.execute(request); 
            java.io.File tempFile  = new java.io.File("/tmp/" + "UploadedLeadsResponse.json"); 
            FileOutputStream fopData  = new FileOutputStream(tempFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));            
            log.info(" Uploaded Leads Response, Output from Server .... \n");
            while ((output = br.readLine()) != null) {               
                System.out.println("Output ==> " + output);
                fopData.write((output +"\n").getBytes(),0,(output +"\n").getBytes().length);
            }
            fopData.flush();
            fopData.close();                      
        }catch (Exception ex) {
            log.error("Exception in SiteServeAuthentication.refreshAccessToken() method" + ex);
        } finally {
            httpClient.getConnectionManager().shutdown();
        }        
    }
}
